<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title') - Application Installer</title>
    
    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --primary-color: #4B8BFF;
            --primary-dark: #2a6ae9;
            --primary-light: #a0c0ff;
            
            --dark-gray: #1E1E1E;
            --dark-gray-lighter: #2A2A2A;
            --dark-gray-lightest: #333333;
            --mid-gray: #606060;
            --light-gray: #9A9A9A;
            --lighter-gray: #E0E0E0;
            
            --white: #FFFFFF;
            --black: #000000;
            
            --success: #4CD964;
            --warning: #FFC107;
            --danger: #FF3B30;
            --info: #5AC8FA;
            
            --font-family-base: 'Poppins', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif;
            --font-size-base: 16px;
            --line-height-base: 1.6;
            
            --spacing-xs: 0.25rem;
            --spacing-sm: 0.5rem;
            --spacing-md: 1rem;
            --spacing-lg: 1.5rem;
            --spacing-xl: 2rem;
            --spacing-xxl: 3rem;
            
            --border-radius-sm: 0.25rem;
            --border-radius-md: 0.5rem;
            --border-radius-lg: 0.75rem;
            --border-radius-xl: 1rem;
            
            --box-shadow-sm: 0 2px 4px rgba(0, 0, 0, 0.05);
            --box-shadow-md: 0 4px 8px rgba(0, 0, 0, 0.1);
            --box-shadow-lg: 0 6px 16px rgba(0, 0, 0, 0.1);
            
            --transition-base: all 0.3s ease;
            --transition-fast: all 0.15s ease;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: var(--font-family-base);
            font-size: var(--font-size-base);
            line-height: var(--line-height-base);
            background: linear-gradient(135deg, var(--dark-gray) 0%, #141414 100%);
            color: var(--lighter-gray);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            position: relative;
            overflow-x: hidden;
        }
        
        /* Background pattern */
        body::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-image: 
                radial-gradient(circle at 25% 25%, rgba(255, 255, 255, 0.02) 1px, transparent 1px),
                radial-gradient(circle at 75% 75%, rgba(255, 255, 255, 0.02) 1px, transparent 1px);
            background-size: 40px 40px;
            pointer-events: none;
            z-index: -1;
        }
        
        .container {
            width: 100%;
            max-width: 880px;
            margin: 0 auto;
            padding: var(--spacing-md);
            position: relative;
            z-index: 1;
        }
        
        .installer-wrapper {
            margin-top: var(--spacing-xl);
            margin-bottom: var(--spacing-xxl);
            background-color: var(--dark-gray-lighter);
            border-radius: var(--border-radius-lg);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2), 
                        0 1px 3px rgba(0, 0, 0, 0.1), 
                        0 0 0 1px rgba(255, 255, 255, 0.05);
            overflow: hidden;
            position: relative;
        }
        
        /* Subtle gradient border effect */
        .installer-wrapper::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            border-radius: var(--border-radius-lg);
            pointer-events: none;
            background: linear-gradient(to bottom right, 
                        rgba(75, 139, 255, 0.3), 
                        transparent, 
                        rgba(75, 139, 255, 0.1));
            z-index: -1;
        }
        
        .installer-header {
            background-color: var(--dark-gray-lightest);
            padding: var(--spacing-xl);
            border-bottom: 1px solid rgba(255, 255, 255, 0.05);
            text-align: center;
            position: relative;
        }
        
        .installer-title {
            font-size: 1.8rem;
            font-weight: 600;
            color: var(--white);
            margin-bottom: var(--spacing-sm);
            letter-spacing: -0.02em;
        }
        
        .installer-subtitle {
            color: var(--light-gray);
            font-size: 1rem;
        }
        
        .installer-content {
            padding: var(--spacing-xl) var(--spacing-xxl);
        }
        
        .installer-footer {
            background-color: var(--dark-gray-lightest);
            padding: var(--spacing-lg) var(--spacing-xl);
            border-top: 1px solid rgba(255, 255, 255, 0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: var(--spacing-md);
        }
        
        .step-indicator {
            display: flex;
            justify-content: center;
            margin-bottom: var(--spacing-xl);
            padding-top: var(--spacing-md);
            position: relative;
        }
        
        .step {
            width: 34px;
            height: 34px;
            border-radius: 50%;
            background-color: var(--dark-gray-lightest);
            color: var(--light-gray);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 0.85rem;
            font-weight: 600;
            margin: 0 var(--spacing-sm);
            position: relative;
            box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.2);
            transition: all 0.3s ease;
            z-index: 2;
        }
        
        .step.active {
            background-color: var(--primary-color);
            color: var(--white);
            box-shadow: 0 0 0 3px rgba(75, 139, 255, 0.2);
        }
        
        .step.completed {
            background-color: var(--success);
            color: var(--white);
        }
        
        .step::after {
            content: '';
            position: absolute;
            width: calc(100% + var(--spacing-md));
            height: 2px;
            background-color: var(--dark-gray-lightest);
            top: 50%;
            left: 100%;
            transform: translateY(-50%);
            z-index: 1;
        }
        
        .step:last-child::after {
            display: none;
        }
        
        .step.completed::after {
            background-color: var(--success);
        }
        
        .form-group {
            margin-bottom: var(--spacing-lg);
        }
        
        .form-label {
            display: block;
            margin-bottom: var(--spacing-xs);
            color: var(--white);
            font-weight: 500;
        }
        
        .form-control {
            width: 100%;
            padding: 0.8rem var(--spacing-md);
            background-color: var(--dark-gray);
            border: 1px solid var(--dark-gray-lightest);
            border-radius: var(--border-radius-md);
            color: var(--white);
            font-family: var(--font-family-base);
            font-size: var(--font-size-base);
            transition: var(--transition-fast);
            box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.1);
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(75, 139, 255, 0.2), inset 0 1px 2px rgba(0, 0, 0, 0.1);
        }
        
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 0.7rem var(--spacing-xl);
            background-color: var(--dark-gray-lightest);
            color: var(--white);
            border: none;
            border-radius: var(--border-radius-md);
            font-family: var(--font-family-base);
            font-size: var(--font-size-base);
            font-weight: 500;
            text-decoration: none;
            cursor: pointer;
            transition: var(--transition-fast);
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            min-width: 110px;
        }
        
        .btn:hover {
            background-color: var(--mid-gray);
            transform: translateY(-1px);
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            color: var(--white);
        }
        
        .btn-primary:hover {
            background-color: var(--primary-dark);
        }
        
        .btn-success {
            background-color: var(--success);
            color: var(--white);
        }
        
        .btn-success:hover {
            background-color: #3dbb55;
        }
        
        .btn i {
            margin-right: var(--spacing-xs);
        }
        
        .btn-link {
            background: none;
            box-shadow: none;
            color: var(--primary-color);
            padding: var(--spacing-xs);
            min-width: auto;
        }
        
        .btn-link:hover {
            background: none;
            box-shadow: none;
            color: var(--primary-light);
            text-decoration: underline;
            transform: none;
        }
        
        .alert {
            padding: var(--spacing-md) var(--spacing-lg);
            border-radius: var(--border-radius-md);
            margin-bottom: var(--spacing-lg);
            display: flex;
            align-items: flex-start;
            gap: var(--spacing-sm);
        }
        
        .alert i {
            font-size: 1.2rem;
            margin-top: 0.1rem;
            flex-shrink: 0;
        }
        
        .alert-danger {
            background-color: rgba(255, 59, 48, 0.1);
            border: 1px solid rgba(255, 59, 48, 0.2);
            color: #ff8d85;
        }
        
        .alert-success {
            background-color: rgba(76, 217, 100, 0.1);
            border: 1px solid rgba(76, 217, 100, 0.2);
            color: #79da8b;
        }
        
        .requirements-list {
            list-style: none;
            background-color: var(--dark-gray);
            border-radius: var(--border-radius-lg);
            overflow: hidden;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }
        
        .requirement-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: var(--spacing-md) var(--spacing-lg);
            border-bottom: 1px solid var(--dark-gray-lighter);
        }
        
        .requirement-item:last-child {
            border-bottom: none;
        }
        
        .requirement-name {
            flex: 1;
            margin-right: var(--spacing-md);
        }
        
        .requirement-status {
            font-weight: 600;
            display: flex;
            align-items: center;
            flex-shrink: 0;
        }
        
        .requirement-status i {
            margin-right: var(--spacing-xs);
        }
        
        .status-passed {
            color: var(--success);
        }
        
        .status-failed {
            color: var(--danger);
        }
        
        .loader {
            display: inline-block;
            width: 24px;
            height: 24px;
            border: 3px solid rgba(255, 255, 255, 0.15);
            border-radius: 50%;
            border-top-color: var(--white);
            animation: spin 1s ease-in-out infinite;
            margin-right: var(--spacing-sm);
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        /* Card-like container for summaries */
        .info-card {
            background-color: var(--dark-gray);
            border-radius: var(--border-radius-lg);
            padding: var(--spacing-lg);
            margin-bottom: var(--spacing-lg);
            border: 1px solid var(--dark-gray-lightest);
        }
        
        .info-card h3 {
            margin-bottom: var(--spacing-md);
            color: var(--white);
            font-size: 1.1rem;
            display: flex;
            align-items: center;
        }
        
        .info-card h3 i {
            margin-right: var(--spacing-sm);
            color: var(--primary-color);
        }
        
        .info-item {
            display: flex;
            margin-bottom: var(--spacing-xs);
            padding-bottom: var(--spacing-xs);
            border-bottom: 1px solid var(--dark-gray-lighter);
            align-items: flex-start;
        }
        
        .info-item:last-child {
            margin-bottom: 0;
            padding-bottom: 0;
            border-bottom: none;
        }
        
        .info-label {
            flex: 0 0 140px;
            font-weight: 500;
            color: var(--light-gray);
        }
        
        .info-value {
            flex: 1;
            color: var(--white);
            word-break: break-word;
        }
        
        /* Welcome screen styling */
        .welcome-icon {
            font-size: 3rem;
            color: var(--primary-color);
            margin-bottom: var(--spacing-md);
            text-align: center;
        }
        
        .feature-list {
            margin: var(--spacing-lg) 0;
        }
        
        .feature-item {
            display: flex;
            align-items: flex-start;
            margin-bottom: var(--spacing-md);
        }
        
        .feature-icon {
            flex: 0 0 24px;
            margin-right: var(--spacing-md);
            color: var(--success);
        }
        
        .feature-text {
            flex: 1;
        }
        
        /* Completion screen styling */
        .completion-icon {
            font-size: 5rem;
            color: var(--success);
            margin-bottom: var(--spacing-lg);
            text-align: center;
        }
        
        /* Touch-friendly improvements */
        .btn {
            min-height: 44px;
            touch-action: manipulation;
        }
        
        .form-control {
            min-height: 44px;
            font-size: 16px; /* Prevents zoom on iOS */
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            body {
                font-size: 14px;
            }
            
            .container {
                padding: var(--spacing-sm);
            }
            
            .installer-wrapper {
                margin-top: var(--spacing-lg);
                margin-bottom: var(--spacing-xl);
                border-radius: var(--border-radius-md);
            }
            
            .installer-header {
                padding: var(--spacing-lg);
            }
            
            .installer-title {
                font-size: 1.5rem;
            }
            
            .installer-subtitle {
                font-size: 0.9rem;
            }
            
            .installer-content {
                padding: var(--spacing-lg);
            }
            
            .installer-footer {
                padding: var(--spacing-md) var(--spacing-lg);
                flex-direction: column;
                align-items: stretch;
            }
            
            .installer-footer .btn {
                width: 100%;
                margin-bottom: var(--spacing-sm);
            }
            
            .installer-footer .btn:last-child {
                margin-bottom: 0;
            }
            
            .step-indicator {
                overflow-x: auto;
                justify-content: flex-start;
                padding: var(--spacing-md) var(--spacing-sm) var(--spacing-xs);
                scroll-snap-type: x mandatory;
                -webkit-overflow-scrolling: touch;
            }
            
            .step-indicator::-webkit-scrollbar {
                display: none;
            }
            
            .step {
                scroll-snap-align: center;
                width: 30px;
                height: 30px;
                margin: 0 var(--spacing-xs);
                font-size: 0.8rem;
                flex-shrink: 0;
            }
            
            .step::after {
                width: calc(100% + var(--spacing-xs));
            }
            
            .info-item {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .info-label {
                flex: none;
                margin-bottom: var(--spacing-xs);
                font-size: 0.85rem;
            }
            
            .info-value {
                font-size: 0.9rem;
            }
            
            .requirement-item {
                padding: var(--spacing-sm) var(--spacing-md);
                flex-direction: column;
                align-items: flex-start;
                gap: var(--spacing-xs);
            }
            
            .requirement-name {
                margin-right: 0;
                margin-bottom: var(--spacing-xs);
            }
            
            .alert {
                flex-direction: column;
                text-align: center;
            }
            
            .alert i {
                margin: 0 0 var(--spacing-xs) 0;
            }
            
            .feature-item {
                margin-bottom: var(--spacing-lg);
            }
            
            .welcome-icon {
                font-size: 2.5rem;
            }
            
            .completion-icon {
                font-size: 4rem;
            }
        }
        
        @media (max-width: 480px) {
            .installer-title {
                font-size: 1.3rem;
            }
            
            .installer-content {
                padding: var(--spacing-md);
            }
            
            .step {
                width: 26px;
                height: 26px;
                font-size: 0.75rem;
            }
            
            .btn {
                padding: 0.6rem var(--spacing-lg);
                font-size: 0.9rem;
            }
            
            .info-card {
                padding: var(--spacing-md);
            }
        }
        
        /* Landscape orientation on mobile */
        @media (max-width: 768px) and (orientation: landscape) {
            .installer-wrapper {
                margin-top: var(--spacing-sm);
                margin-bottom: var(--spacing-md);
            }
            
            .installer-header {
                padding: var(--spacing-md);
            }
            
            .installer-content {
                padding: var(--spacing-md);
            }
        }
        
        /* High DPI displays */
        @media (-webkit-min-device-pixel-ratio: 2), (min-resolution: 192dpi) {
            .installer-wrapper {
                box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15), 
                            0 1px 3px rgba(0, 0, 0, 0.08), 
                            0 0 0 1px rgba(255, 255, 255, 0.04);
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="installer-wrapper">
            <div class="installer-header">
                <h1 class="installer-title">Edge Suite Installer</h1>
                <p class="installer-subtitle">@yield('subtitle', 'Follow the steps to install your application')</p>
            </div>
            
            <div class="step-indicator">
                <div class="step {{ request()->routeIs('installer.index') ? 'active' : (request()->routeIs('installer.requirements') || request()->routeIs('installer.license') || request()->routeIs('installer.database') || request()->routeIs('installer.app') || request()->routeIs('installer.install') || request()->routeIs('installer.complete') ? 'completed' : '') }}">1</div>
                <div class="step {{ request()->routeIs('installer.requirements') ? 'active' : (request()->routeIs('installer.license') || request()->routeIs('installer.database') || request()->routeIs('installer.app') || request()->routeIs('installer.install') || request()->routeIs('installer.complete') ? 'completed' : '') }}">2</div>
                <div class="step {{ request()->routeIs('installer.license') ? 'active' : (request()->routeIs('installer.database') || request()->routeIs('installer.app') || request()->routeIs('installer.install') || request()->routeIs('installer.complete') ? 'completed' : '') }}">3</div>
                <div class="step {{ request()->routeIs('installer.database') ? 'active' : (request()->routeIs('installer.app') || request()->routeIs('installer.install') || request()->routeIs('installer.complete') ? 'completed' : '') }}">4</div>
                <div class="step {{ request()->routeIs('installer.app') ? 'active' : (request()->routeIs('installer.install') || request()->routeIs('installer.complete') ? 'completed' : '') }}">5</div>
                <div class="step {{ request()->routeIs('installer.install') ? 'active' : (request()->routeIs('installer.complete') ? 'completed' : '') }}">6</div>
                <div class="step {{ request()->routeIs('installer.complete') ? 'active' : '' }}">7</div>
            </div>
            
            @if(session('error'))
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-circle"></i>
                    <span>{{ session('error') }}</span>
                </div>
            @endif
            
            @if(session('success'))
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i>
                    <span>{{ session('success') }}</span>
                </div>
            @endif
            
            <div class="installer-content">
                @yield('content')
            </div>
            
            <div class="installer-footer">
                @yield('footer')
            </div>
        </div>
    </div>
    
    @yield('scripts')
</body>
</html>